//---------------------------------------------------------------------------

#ifndef mainH
#define mainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include "common.h"
#include "CommControl_Form.h"
#include "Message_Form.h"
#include <ComCtrls.hpp>
#include <Graphics.hpp>
#include <ImgList.hpp>
#include <Buttons.hpp>
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntButtons.hpp"

#define BOARD_COUNT_MAX 		6

#define PROGRAM_TABLET_APPLICATION    0
#define PROGRAM_CAPSULE_APPLICATION   1

#define FW_VERSION_HCB_TABLET       0
#define FW_VERSION_HCB_CAPSULE      1
#define FW_VERSION_SPB_TABLET       2
#define FW_VERSION_SPB_CAPSULE      3
#define FW_VERSION_NOT_DOWNLOAD     4
#define FW_VERSION_TPB_TABLET       5
#define FW_VERSION_TPB_CAPSULE      6

#define VIRTUAL_OUTPUT_PORT_COUNT		64
#define VIRTUAL_INPUT_PORT_COUNT		64
#define MAX_VOP_COUNT						    64
#define MAX_VIP_COUNT						    64
#define PORT_NOT_EXIST						0xFF
#define PHYSICAL_OUTPUT_PORT_COUNT		64
#define PHYSICAL_INPUT_PORT_COUNT		  64
#define POP_NOT_EXIST	255
#define PIP_NOT_EXIST	255


#define TARGET_MACHINE_REV				(('D' << 24) | ('5' << 16) | (500))

#define TARGET_HCB_PROGRAM_REV			106		// data structure  ǹѴ.
#define TARGET_HCB_DATA_REV				106
#define TARGET_SPB_PROGRAM_REV			106
#define TARGET_SPB_DATA_REV				106

#define CAMERA_SETTING_ADDR_GAIN_TYPE   1
#define CAMERA_SETTING_ADDR_GAIN_VALUE  8

#define CAMERA_SETTING_DATA_GAINTYPE 4

#define BOARD_TYPE_HCB  0
#define BOARD_TYPE_SPB  1
#define BOARD_TYPE_TPB  2


#define BOOT_PROCESS_BOARD_CONNECTION       0
#define BOOT_PROCESS_STABLE_WAITING1        1
#define BOOT_PROCESS_CHECK_SPB_VERSION      2
#define BOOT_PROCESS_SPB_BOOTING            3
#define BOOT_PROCESS_STABLE_WAITING2        4
#define BOOT_PROCESS_LOAD_SPB               5
#define BOOT_PROCESS_CHECK_HCB_VERSION      6
#define BOOT_PROCESS_HCB_BOOTING            7
#define BOOT_PROCESS_STABLE_WAITING3        8
#define BOOT_PROCESS_LOAD_HCB               9
#define BOOT_PROCESS_BOARD_DISCONNECTION    10
#define BOOT_PROCESS_STABLE_WAITING4        11
#define BOOT_PROCESS_EXECUTION_UI           12
#define BOOT_PROCESS_VARIABLE_INITIAL       13
#define BOOT_PROCESS_CHECK_TPB_VERSION      14
#define BOOT_PROCESS_TPB_BOOTING            15
#define BOOT_PROCESS_LOAD_TPB               16

#define PRG_CLOSE_OPTION_NONE               0
#define PRG_CLOSE_OPTION_SAVE_AND_EXIT      1
#define PRG_CLOSE_OPTION_INVALID_DATA       2

#define BOARD_CONNECTED				1
#define BOARD_NOT_CONNECTED		0


typedef struct
{
  unsigned int MachineRev;
  unsigned char VIPMap[VIRTUAL_INPUT_PORT_COUNT];
  unsigned char VOPMap[VIRTUAL_OUTPUT_PORT_COUNT];
} TPortMapInfo;

typedef struct
{
  unsigned char PortMapValue;
} TPortMapInfoData;


//---------------------------------------------------------------------------
class TMain_form : public TForm
{
__published:	// IDE-managed Components
  TPanel *Panel1;
  TImage *executionBtn1;
  TImage *executionBtn2;
  TTimer *StatusCheckTimer;
  TGroupBox *GroupBox3;
  TTntShape *BoardCommStatusShape1;
  TLabel *Label1;
  TLabel *CommTypeLabel1;
  TLabel *IPBNumberLabel1;
  TLabel *CommTypeLabel2;
  TTntShape *BoardCommStatusShape2;
  TLabel *IPBNumberLabel2;
  TLabel *CommTypeLabel3;
  TTntShape *BoardCommStatusShape3;
  TLabel *IPBNumberLabel3;
  TLabel *CommTypeLabel4;
  TTntShape *BoardCommStatusShape4;
  TLabel *IPBNumberLabel4;
  TLabel *CommTypeLabel5;
  TTntShape *BoardCommStatusShape5;
  TLabel *HCBVersionLabel;
  TLabel *SPBVersionLabel1;
  TLabel *SPBVersionLabel2;
  TLabel *SPBVersionLabel3;
  TLabel *SPBVersionLabel4;
  TTimer *SystemBootingCheckTimer;
  TPanel *Panel5;
  TPanel *Panel2;
  TProgressBar *WaitngBar;
  TPanel *Panel6;
  TPanel *Panel7;
  TGroupBox *GroupBox2;
  TTntShape *TntShape1;
  TLabel *Label4;
  TLabel *IPBNumberLabel5;
  TLabel *CommTypeLabel6;
  TLabel *SPBVersionLabel5;
  TTntShape *BoardCommStatusShape6;
  TTimer *Timer1;
  TLabel *IPBNumberLabel6;
  TLabel *CommTypeLabel7;
  TLabel *SPBVersionLabel6;
  TTntShape *BoardCommStatusShape7;
  TButton *FWResetBtn;
  TButton *OptionSettingBtn;
  TLabel *IPBNumberLabel7;
  TLabel *CommTypeLabel8;
  TLabel *SPBVersionLabel7;
  TTntShape *BoardCommStatusShape8;
  TLabel *IPBNumberLabel8;
  TLabel *CommTypeLabel9;
  TLabel *SPBVersionLabel8;
  TTntShape *BoardCommStatusShape9;
  TPanel *Panel8;
  TLabel *TPBNumberLabel;
  TLabel *CommTypeLabel10;
  TLabel *TPBVersionLabel;
  TTntShape *BoardCommStatusShape10;
	TTimer *BoardResetCheckTimer;
	TPanel *BootCheckPanel;
	TLabel *Label2;
	TLabel *Label3;
	TLabel *Label5;
	TLabel *Label6;
	TLabel *Label7;
	TLabel *Label8;
	TLabel *Label9;
	TLabel *ResetCheckLabel_IPB7_Title;
	TLabel *ResetCheckLabel_IPB8_Title;
	TLabel *ResetCheckLabel_HCB;
	TLabel *ResetCheckLabel_IPB1;
	TLabel *ResetCheckLabel_IPB2;
	TLabel *ResetCheckLabel_IPB3;
	TLabel *ResetCheckLabel_IPB4;
	TLabel *ResetCheckLabel_IPB5;
	TLabel *ResetCheckLabel_IPB6;
	TLabel *ResetCheckLabel_IPB7;
	TLabel *ResetCheckLabel_IPB8;
	TLabel *Label12;
  void __fastcall executionBtn2Click(TObject *Sender);
  void __fastcall Panel4DblClick(TObject *Sender);
  void __fastcall executionBtn1Click(TObject *Sender);
  void __fastcall FormCreate(TObject *Sender);
  void __fastcall FormActivate(TObject *Sender);
  void __fastcall Panel1DblClick(TObject *Sender);
  void __fastcall StatusCheckTimerTimer(TObject *Sender);
  void __fastcall SystemBootingCheckTimerTimer(TObject *Sender);
  void __fastcall Panel7Click(TObject *Sender);
  void __fastcall Panel7MouseDown(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
  void __fastcall Panel7MouseUp(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
  void __fastcall Timer1Timer(TObject *Sender);
  void __fastcall FWResetBtnClick(TObject *Sender);
  void __fastcall OptionSettingBtnClick(TObject *Sender);
	void __fastcall BoardResetCheckTimerTimer(TObject *Sender);
private:	// User declarations
  void __fastcall ProgramExecution(AnsiString ProgramName);
  AnsiString __fastcall ApplicationProgramName(int ProgramType);
  void __fastcall FirmWareReset(int ProgramType);
  void __fastcall HCB_ProgramReset(int ProgramType);
  void __fastcall SPB_ProgramReset(int ProgramType);
  void __fastcall TPB_ProgramReset(int ProgramType);
  void __fastcall CreateProgramFolder();
  void __fastcall PastFirmwareConfirm(int programType);
  void __fastcall DownloadFirmwareReport(int programType, int FW_Version);
  void __fastcall HCBSystemSetup(int programType);
  bool __fastcall ReadUserMachineEnvData(AnsiString fileName, TUserMachineEnv &userMachineEnv);
  bool __fastcall MakePortMapInfo(AnsiString FileName, TPortMapInfo &PortMapInfo, unsigned int machineRev);
  bool __fastcall ReadMachineSetupData(AnsiString fileName, TMachineSetupData &machineSetupData);
  void __fastcall SPBSystemSetup(int spbIndex, int programType);
  bool __fastcall ReadSPBSystemSetupData(AnsiString fileName, TSPBSystemSetupData *spbSystemSetupData,
  TCameraMapInfo *cameraMapInfo);
  void __fastcall SetCommParameter();
  void __fastcall SetCommTypeLabel();
  bool __fastcall IsExistProcess(AnsiString ProcessName);
  bool __fastcall KillProcess(AnsiString ProcessName);
  bool __fastcall BoardBootingCheckProcess(int BoardType);
  void __fastcall SystemBootingProcess();
  void __fastcall VersionCheckProcess();
  void __fastcall RefreshBoardCountComponents();
  void __fastcall RunsLaser();

  int PastFW_HCB;
  int PastFW_SPB;
  int PastFW_TPB;
  
  int CurrentFW_HCB;
  int CurrentFW_SPB;
  int CurrentFW_TPB;

  bool bProgramExecution;
  bool bStatusCheckTimerSw;
  bool BootingStopButton;
  bool bConnectedBoard[MAX_COMM_COUNT];

  int WaitingTimeCount;

  int checkedSPB[SYSTEM_SPB_COUNT];
  int checkedTPB;
  int SystemBootingCommand;
  int timeCheck;

  bool bAllConnected;
  int ConnectedCount;

  int ProgramType;
  int bPgmClose;

  TProgramVersion HCBVersion;
  TProgramVersion SPBVersion[SYSTEM_SPB_COUNT];
  TProgramVersion TPBVersion;

  bool bBootingCheckTimerEnabled;
  int CpbRun;
  bool InitDlayTimer;
  bool BoardShutDown;
  int DownCode[MAX_COMM_COUNT];

  WideString tvmExename;
  WideString cvmExename;
  WideString tvm15LicenseName;
  WideString tvm20LicenseName;
  WideString cvm15LicenseName;
  WideString cvm20LicenseName;

public:		// User declarations
  __fastcall TMain_form(TComponent* Owner);
  void __fastcall TMain_form::ProgramPathSetup();
  void __fastcall _SetKeyHookReg(const char* First_PATH , const char* Second_PATH ,bool AccessState);
  void __fastcall BootCheckStatusInit();  
  };
//---------------------------------------------------------------------------
extern PACKAGE TMain_form *Main_form;
//---------------------------------------------------------------------------
#endif
